

// wasm or wasmtime API.
// wasmtime API mode is not complete as this time.
#define API_WASMTIME 0

// fizzbuzz, etc - _start() import or infinity app configuration.

// standard wasi app is faulting - something not quite right - clues welcome.
// think it's something to do with environ_sizes_get_callback but unsure.
#define TEST_INFINITY_APP 1


#ifdef _WIN32

#define _CRT_SECURE_NO_WARNINGS 1

// For OutputDebugString
#include <windows.h>
#include <cstdio>

#if 1
// Static
#define WASM_API_EXTERN
#define WASI_API_EXTERN
#pragma comment(lib, "wasmtime.lib")
#pragma comment(lib, "ws2_32.lib")
#pragma comment(lib, "advapi32.lib")
#pragma comment(lib, "userenv.lib")
#pragma comment(lib, "ntdll.lib")
#pragma comment(lib, "shell32.lib")
#pragma comment(lib, "ole32.lib")
#pragma comment(lib, "bcrypt.lib")
#else
// Dynamic
//#pragma comment(lib, "wasmtime.dll.lib")
#endif

#endif // _WIN32



static void Logf(const char* format, ...)
{
   va_list arg_list;
   va_start(arg_list, format);

   // Get the required buffer size
   int len = vsnprintf(nullptr, 0, format, arg_list);
   va_end(arg_list);

   if (len < 0) return;

   // Allocate buffer and format the string
   char* s = new char[len + 1];

   va_start(arg_list, format);
   vsnprintf(s, len + 1, format, arg_list);
   va_end(arg_list);

   // Custom logging delivery.
   printf(s);
   OutputDebugStringA(s);

   delete[] s;
}


#include <wasmtime.h>

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(x) (sizeof(x) / sizeof(x[0]))
#endif


// Hardwired entrypoint.
#if TEST_INFINITY_APP
static  const char* entrypoint = "app_init"; 
#else
static  const char* entrypoint = "_start";
#endif



#if API_WASMTIME
wasmtime_store_t * _store = nullptr;
wasmtime_context_t* _context = nullptr;
#else
wasm_store_t* _store = nullptr;
wasm_memory_t* _memory = nullptr;

wasm_func_t* _init_fn = nullptr;
wasm_extern_vec_t _exports;

static int _export_init_fn = -1;

#define WASM_VEC(x) { 1, &(x) }
#define WASM_VEC_EMPTY { 0, nullptr }

#endif


static wasm_functype_t* __ft_i32_out_i32 = nullptr;
static wasm_functype_t* __ft_i32_i32_out_i32 = nullptr;
static wasm_functype_t* __ft_i32_i32_i32_i32_out_i32 = nullptr;
static wasm_functype_t* __ft_i32_i64_i32_i32_out_i32 = nullptr;
static wasm_functype_t* __ft_i32_i32_i32_out_i32 = nullptr;
static wasm_functype_t* __ft_i32_out_void = nullptr;


static wasm_functype_t* wasm_functype_new_4_1(wasm_valtype_t* p1, wasm_valtype_t* p2, wasm_valtype_t* p3,
   wasm_valtype_t* p4, wasm_valtype_t* r)
{
   wasm_valtype_t* ps[4] = { p1, p2, p3, p4 };
   wasm_valtype_t* rs[1] = { r };
   wasm_valtype_vec_t params, results;
   wasm_valtype_vec_new(&params, ARRAY_SIZE(ps), ps);
   wasm_valtype_vec_new(&results, ARRAY_SIZE(rs), rs);
   return wasm_functype_new(&params, &results);
}

// Helper to safely get linear memory pointer & size
static bool get_memory_data(wasm_memory_t* mem, wasm_byte_t** out_data, size_t* out_size)
{
   if (!mem) {
      *out_data = nullptr;
      *out_size = 0;
      return false;
   }

   *out_data = wasm_memory_data(mem);
   *out_size = wasm_memory_data_size(mem);
   return (*out_data != nullptr && *out_size > 0);
}


static void Function_Types_Init()
{
#if 0
   wasm_valtype_t* val_i32 = wasm_valtype_new(WASM_I32);
   wasm_valtype_t* val_i64 = wasm_valtype_new(WASM_I64);

   // Binding function signatures ...

   __ft_i32_out_i32 = wasm_functype_new_1_1(val_i32, val_i32);
   __ft_i32_i32_out_i32 = wasm_functype_new_2_1(val_i32, val_i32, val_i32);
   __ft_i32_i32_i32_i32_out_i32 = wasm_functype_new_4_1(val_i32, val_i32, val_i32, val_i32, val_i32);
   __ft_i32_i64_i32_i32_out_i32 = wasm_functype_new_4_1(val_i32, val_i64, val_i32, val_i32, val_i32);

   wasm_valtype_delete(val_i32);
   wasm_valtype_delete(val_i64);
#else
   __ft_i32_out_i32 = wasm_functype_new_1_1(wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32));
   __ft_i32_i32_out_i32 = wasm_functype_new_2_1(wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32));
   __ft_i32_i32_i32_i32_out_i32 = wasm_functype_new_4_1(wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32));
   __ft_i32_i64_i32_i32_out_i32 = wasm_functype_new_4_1(wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I64), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32));

   __ft_i32_i32_i32_out_i32 = wasm_functype_new_3_1(wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32), wasm_valtype_new(WASM_I32));
   __ft_i32_out_void = wasm_functype_new_1_0(wasm_valtype_new(WASM_I32));


#endif
}


const uint32_t INF_WASM_IMPORTS_SYS = 6;
static int _imports_sys[INF_WASM_IMPORTS_SYS] = { -1, -1,  -1 , -1, -1, -1 };
enum Imports_Sys { import_fd_write = 0, import_proc_exit = 1, import_environ_get = 2, import_environ_sizes_get = 3, import_fd_close = 4, import_fd_seek = 5, import_memory = 6 };


const uint32_t INF_WASM_IMPORTS_INFINITY = 3;
static int _imports_inf[INF_WASM_IMPORTS_INFINITY] = { -1, -1, -1 };
enum Imports_Sys_Infinity { import_create_native = 0, import_release_native = 1, import_native_op = 2 };



static void exit_with_error(const char* message) {
   fprintf(stderr, "Error: %s\n", message);
   exit(1);
}



#if 0 //API_WASMTIME
// TODO: Each as wasmtime_func_callback_t
#else


static wasm_trap_t* fd_close_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   return nullptr;
}

static wasm_trap_t* fd_seek_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   return nullptr;
}

static wasm_trap_t* fd_write_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   if (_args->size != 4 || _results->size != 1) {
      return wasmtime_trap_new("arity mismatch", strlen("arity mismatch"));
      //return wasm_trap_new(_store, "arity mismatch", strlen("arity mismatch"));
   }

   _results->data[0].kind = WASM_I32;
   _results->data[0].of.i32 = 0;  // 0 bytes written (minimal: no-op)

   return nullptr;
}

static wasm_trap_t* environ_get_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   return nullptr;
}

static wasm_trap_t* environ_sizes_get_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   // WASI environ_sizes_get has signature:
       // (i32, i32) -> (i32)
   if (_args->size != 2 || _results->size != 1)
      return wasmtime_trap_new("arity mismatch", strlen("arity mismatch"));

   // Get memory buffer
   wasm_byte_t *mem_data;
   size_t mem_size;
   if (!get_memory_data(_memory, &mem_data, &mem_size))
      return wasmtime_trap_new("mem access fail", strlen("mem access fail"));

   // Access pointers passed by WASM guest
   uint32_t count_ptr = _args->data[0].of.i32;
   uint32_t buf_size_ptr = _args->data[1].of.i32;

   // Sanity check addresses
   if (count_ptr + 4 > mem_size || buf_size_ptr + 4 > mem_size)
      return wasmtime_trap_new("memory", strlen("memory"));

   // Write zeroes: count=0, buf_size=0
   *(uint32_t*)(mem_data + count_ptr) = 0;
   *(uint32_t*)(mem_data + buf_size_ptr) = 0;

   // Return errno = 0 (success)
   _results->data[0].kind = WASM_I32;
   _results->data[0].of.i32 = 0;

   return nullptr; // no trap
}


static wasm_trap_t* proc_exit_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   // TODO
   return nullptr;
}

static wasm_trap_t* create_native_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   // TODO
   return nullptr;
}

static wasm_trap_t* release_native_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   // TODO
   return nullptr;
}

static wasm_trap_t* native_op_callback(void* user, const wasm_val_vec_t* _args, wasm_val_vec_t* _results)
{
   // TODO
   return nullptr;
}

#endif


static void Import_Bind(wasm_extern_t** imports, int import_index, wasm_extern_t* import)
{
   if (import_index >= 0)
      imports[import_index] = import;
}


static void Bind_Native_WASI(void* user, wasm_extern_t** imports)
{
   // Sys expected - WASI ?
   wasm_func_t* fn_fd_close = wasm_func_new_with_env(_store, __ft_i32_out_i32, fd_close_callback, user, nullptr);
   wasm_func_t* fn_fd_seek = wasm_func_new_with_env(_store, __ft_i32_i64_i32_i32_out_i32, fd_seek_callback, user, nullptr);
   wasm_func_t* fn_fd_write = wasm_func_new_with_env(_store, __ft_i32_i32_i32_i32_out_i32, fd_write_callback, user, nullptr);
   wasm_func_t* fn_environ_get = wasm_func_new_with_env(_store, __ft_i32_i32_out_i32, environ_get_callback, user, nullptr);
   wasm_func_t* fn_environ_sizes_get = wasm_func_new_with_env(_store, __ft_i32_i32_out_i32, environ_sizes_get_callback, user, nullptr);
   wasm_func_t* fn_proc_exit = wasm_func_new_with_env(_store, __ft_i32_out_void, proc_exit_callback, user, nullptr);

   if (_imports_sys[import_fd_close] != -1)
      Import_Bind(imports, _imports_sys[import_fd_close], wasm_func_as_extern(fn_fd_close));

   if (_imports_sys[import_fd_seek] != -1)
      Import_Bind(imports, _imports_sys[import_fd_seek], wasm_func_as_extern(fn_fd_seek));

   if (_imports_sys[import_fd_write] != -1)
      Import_Bind(imports, _imports_sys[import_fd_write], wasm_func_as_extern(fn_fd_write));

   if (_imports_sys[import_environ_get] != -1)
      Import_Bind(imports, _imports_sys[import_environ_get], wasm_func_as_extern(fn_environ_get));

   if (_imports_sys[import_environ_sizes_get] != -1)
      Import_Bind(imports, _imports_sys[import_environ_sizes_get], wasm_func_as_extern(fn_environ_sizes_get));

   if (_imports_sys[import_proc_exit] != -1)
      Import_Bind(imports, _imports_sys[import_proc_exit], wasm_func_as_extern(fn_proc_exit));
}


#if TEST_INFINITY_APP
static void Bind_Native_Infinity(void* user, wasm_extern_t** imports)
{

#if API_WASMTIME
   wasm_func_t* create_native_func = wasmtime_func_new(_context, __ft_i32_out_i32, create_native_callback, user, nullptr, nullptr);
   wasm_func_t* release_native_func = wasmtime_func_new(_context, __ft_i32_i32_out_i32, release_native_callback, user, nullptr, nullptr);
   wasm_func_t* native_op_func = wasmtime_func_new(_context, __ft_i32_i32_i32_i32_out_i32, native_op_callback, user, nullptr, nullptr);
#else
   wasm_func_t* create_native_func = wasm_func_new_with_env(_store, __ft_i32_out_i32, create_native_callback, user, nullptr);
   wasm_func_t* release_native_func = wasm_func_new_with_env(_store, __ft_i32_i32_out_i32, release_native_callback, user, nullptr);
   wasm_func_t* native_op_func = wasm_func_new_with_env(_store, __ft_i32_i32_i32_i32_out_i32, native_op_callback, user, nullptr);
#endif

   Import_Bind(imports, _imports_inf[import_release_native], wasm_func_as_extern(release_native_func));
   Import_Bind(imports, _imports_inf[import_create_native], wasm_func_as_extern(create_native_func));
   Import_Bind(imports, _imports_inf[import_native_op], wasm_func_as_extern(native_op_func));
}
#endif


#if !API_WASMTIME


static bool Analyze_Imports(wasm_module_t* _module)
{
   // Scan  imports ...
   wasm_importtype_vec_t imports;
   wasm_module_imports(_module, &imports);

   bool error = false;

   // Look for specific expected import signatives & record their location so we can patch accordingly.
   for (auto i = 0; i < imports.size; ++i)
   {
      auto id = wasm_importtype_name(imports.data[i]);
      auto type_info = wasm_importtype_type(imports.data[i]);

      bool expected = false;

#if TEST_INFINITY_APP

      if (!strncmp("create_native", id->data, strlen("create_native")))
      {
         if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
         {
            const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

            // Check parameters ...
            auto param_sig = wasm_functype_params(func_type);
            bool param_match = false;

            if (param_sig->size == 1)
            {
               if (wasm_valtype_kind(param_sig->data[0]) == WASM_I32)
                  param_match = true;
            }

            // Check return sig ...
            auto return_sig = wasm_functype_results(func_type);
            bool return_sig_match = false;

            if (return_sig->size == 1)
            {
               if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                  return_sig_match = true;
            }

            expected = return_sig_match && param_match;


            if (expected)
               _imports_inf[import_create_native] = i;
         }
      }

      else if (!strncmp("release_native", id->data, strlen("release_native")))
      {
         if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
         {
            const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

            // Check parameters ...
            auto param_sig = wasm_functype_params(func_type);
            bool param_match = false;

            if (param_sig->size == 2)
            {
               if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                  (wasm_valtype_kind(param_sig->data[1]) == WASM_I32))
                  param_match = true;
            }

            // Check return sig ...
            auto return_sig = wasm_functype_results(func_type);
            bool return_sig_match = false;

            if (return_sig->size == 1)
            {
               if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                  return_sig_match = true;
            }

            expected = return_sig_match && param_match;

            if (expected)
               _imports_inf[import_release_native] = i;
         }
      }

      else if (!strncmp("native_op", id->data, strlen("native_op")))
      {
         if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
         {
            const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

            // Check parameters ...
            auto param_sig = wasm_functype_params(func_type);
            bool param_match = false;

            if (param_sig->size == 4)
            {
               if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                  (wasm_valtype_kind(param_sig->data[1]) == WASM_I32) &&
                  (wasm_valtype_kind(param_sig->data[2]) == WASM_I32) &&
                  (wasm_valtype_kind(param_sig->data[3]) == WASM_I32))
                  param_match = true;
            }

            // Check return sig ...
            auto return_sig = wasm_functype_results(func_type);
            bool return_sig_match = false;

            if (return_sig->size == 1)
            {
               if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                  return_sig_match = true;
            }

            expected = return_sig_match && param_match;

            if (expected)
               _imports_inf[import_native_op] = i;
         }
      }
      else
#endif

         if (!strncmp("fd_close", id->data, strlen("fd_close")))
         {
            if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 1)
               {
                  if (wasm_valtype_kind(param_sig->data[0]) == WASM_I32)
                     param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = false;

               if (return_sig->size == 1)
               {
                  if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                     return_sig_match = true;
               }

               expected = return_sig_match && param_match;

               if (expected)
                  _imports_sys[import_fd_close] = i;
            }
         }


         else if (!strncmp("fd_write", id->data, strlen("fd_write")))
         {
            if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 4)
               {
                  if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[1]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[2]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[3]) == WASM_I32))
                     param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = false;

               if (return_sig->size == 1)
               {
                  if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                     return_sig_match = true;
               }

               expected = return_sig_match && param_match;

               if (expected)
                  _imports_sys[import_fd_write] = i;
            }
         }

         else if (!strncmp("fd_seek", id->data, strlen("fd_seek")))
         {
            if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 4)
               {
                  if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[1]) == WASM_I64) &&
                     (wasm_valtype_kind(param_sig->data[2]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[3]) == WASM_I32))
                     param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = false;

               if (return_sig->size == 1)
               {
                  if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                     return_sig_match = true;
               }

               expected = return_sig_match && param_match;

               if (expected)
                  _imports_sys[import_fd_seek] = i;
            }
         }


         else if (!strncmp("proc_exit", id->data, strlen("proc_exit")))
         {
            if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 1)
               {
                  if (wasm_valtype_kind(param_sig->data[0]) == WASM_I32)
                     param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = (return_sig->size == 0);

               expected = return_sig_match && param_match;

               if (expected)
                  _imports_sys[import_proc_exit] = i;
            }
         }

         else if (!strncmp("environ_get", id->data, strlen("environ_get")))
         {
            if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 2)
               {
                  if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[1]) == WASM_I32))
                     param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = false;

               if (return_sig->size == 1)
               {
                  if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                     return_sig_match = true;
               }

               expected = return_sig_match && param_match;

               if (expected)
                  _imports_sys[import_environ_get] = i;
            }
         }
         else if (!strncmp("environ_sizes_get", id->data, strlen("environ_sizes_get")))
         {
            if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 2)
               {
                  if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[1]) == WASM_I32))
                     param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = false;

               if (return_sig->size == 1)
               {
                  if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                     return_sig_match = true;
               }

               expected = return_sig_match && param_match;

               if (expected)
                  _imports_sys[import_environ_sizes_get] = i;
            }
         }


#endif


      if (!expected)
      {
         Logf("Warning : Unexpected import %d ", i);
         // print_name(id);

         Logf("\t\t");

         //print_extern_type_info(type_info);
         Logf("\n");
      }

      //error |= !expected;
   }

   wasm_importtype_vec_delete(&imports);

   return !error;
}


static bool Analyze_Exports(wasm_module_t* _module, wasm_instance_t* _instance)
{
   // Extract export.
   wasm_exporttype_vec_t export_types;
   wasm_module_exports(_module, &export_types);

   wasm_extern_vec_t exports;
   wasm_instance_exports(_instance, &exports);

   if (export_types.size == 0)
   {
      printf("Error : Module contains no exported functions.\n");
      return false;
   }


   // Scan for exports we're expecting.
   for (auto i = 0; i < export_types.size; ++i)
   {
      auto etype = wasm_exporttype_type(export_types.data[i]);

      if (wasm_externtype_kind(etype) == WASM_EXTERN_MEMORY)
      {
         auto id = wasm_exporttype_name(export_types.data[i]);
         if (!strncmp("memory", id->data, strlen("memory")))
         {

            // Get the matching extern
            wasm_extern_t* ext = exports.data[i];

            // Grab memory handle
            _memory = wasm_extern_as_memory(ext);
         }
      }
      else if (wasm_externtype_kind(etype) == WASM_EXTERN_FUNC)
      {
         auto type_info = wasm_exporttype_type(export_types.data[i]);

         if (wasm_externtype_kind(type_info) == WASM_EXTERN_FUNC)
         {
            auto id = wasm_exporttype_name(export_types.data[i]);

#if TEST_INFINITY_APP
            if (!strncmp("app_init", id->data, strlen("app_init")))
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               if (param_sig->size == 3)
               {
                  if ((wasm_valtype_kind(param_sig->data[0]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[1]) == WASM_I32) &&
                     (wasm_valtype_kind(param_sig->data[2]) == WASM_I32))
                     param_match = true;

                  param_match = true;
               }

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = false;

               if (return_sig->size == 1)
               {
                  if (wasm_valtype_kind(return_sig->data[0]) == WASM_I32)
                     return_sig_match = true;
               }


               if (return_sig_match && param_match)
                  _export_init_fn = i;
            }
#else
            if (!strncmp("_start", id->data, strlen("_start")))
            {
               const wasm_functype_t* func_type = wasm_externtype_as_functype_const(type_info);

               // Check parameters ...
               auto param_sig = wasm_functype_params(func_type);
               bool param_match = false;

               param_match = (param_sig->size == 0);

               // Check return sig ...
               auto return_sig = wasm_functype_results(func_type);
               bool return_sig_match = (return_sig->size == 0);

               if (return_sig_match && param_match)
                  _export_init_fn = i;
            }
         }
#endif

      }
   }
}

   wasm_exporttype_vec_delete(&export_types);

   return (_export_init_fn != -1);
}


int wasm_test(const char* filename)
{
   // Configure engine with debug info
   wasm_config_t* config = wasm_config_new();
   wasmtime_config_debug_info_set(config, true);  // Enable DWARF debug info

   wasm_engine_t* engine = wasm_engine_new_with_config(config);
   if (!engine) exit_with_error("Failed to create engine");


#if API_WASMTIME
   _store = wasmtime_store_new(engine, NULL, NULL);
#else
   _store = wasm_store_new(engine);
#endif

   if (!_store) exit_with_error("Failed to create store");

#if API_WASMTIME
   _context = wasmtime_store_context(_store);
#endif

   // Read .wasm ....
   Logf("Loading: %s\n\n", filename);

   FILE* file = fopen(filename, "rb");
   if (!file) exit_with_error("Failed to open wasm file");

   fseek(file, 0, SEEK_END);
   long file_size = ftell(file);
   rewind(file);

   wasm_byte_vec_t wasm_bytes;
   wasm_byte_vec_new_uninitialized(&wasm_bytes, file_size);
   fread(wasm_bytes.data, 1, file_size, file);
   fclose(file);


#if API_WASMTIME
   // Compile the module
   wasmtime_module_t* module = NULL;
   wasmtime_error_t* error = wasmtime_module_new(engine, (uint8_t*)wasm_bytes.data, wasm_bytes.size, &module);

   if (error) {
      wasm_name_t msg;
      wasmtime_error_message(error, &msg);
      fprintf(stderr, "Error compiling module: %.*s\n", (int)msg.size, msg.data);
      wasm_byte_vec_delete(&msg);
      wasmtime_error_delete(error);
      exit(1);
   }
#else
   wasm_byte_vec_t binary;
   wasm_byte_vec_new_uninitialized(&binary, wasm_bytes.size);
   memcpy(binary.data, wasm_bytes.data, wasm_bytes.size);
   wasm_module_t* module = wasm_module_new(_store, &binary);
   wasm_byte_vec_delete(&binary);
#endif

   wasm_byte_vec_delete(&wasm_bytes);

   // Instantiate the module
   wasm_trap_t* trap = nullptr;

#if API_WASMTIME
   wasmtime_instance_t instance;
   error = wasmtime_instance_new(_context, module, NULL, 0, &instance, &trap);
#else

   // Instantiate.
   const auto total_imports = INF_WASM_IMPORTS_INFINITY + INF_WASM_IMPORTS_SYS;
   wasm_extern_t* imports[total_imports];
   memset(&imports, 0, sizeof(wasm_extern_t*) * total_imports);


   if (!Analyze_Imports(module))
      exit(1);

   Function_Types_Init();
   Bind_Native_WASI(nullptr, imports);

#if TEST_INFINITY_APP
   Bind_Native_Infinity(nullptr, imports);
#endif

   wasm_trap_t* err = nullptr;
   wasm_extern_vec_t _imports = WASM_ARRAY_VEC(imports);

   wasm_instance_t* instance;
   instance = wasm_instance_new(_store, module, &_imports, &err);

   if (!instance) {
      if (err) {
         wasm_message_t message;
         wasm_trap_message(err, &message);
         Logf("Error: %.*s\n", (int)message.size, message.data);
         wasm_byte_vec_delete(&message);
         wasm_trap_delete(err);
      }
      else {
         printf("Instance creation failed without trap.\n");
      }
   }


   wasm_instance_exports(instance, &_exports);


   bool ok = true;

   // Resolve required function entry points ...
   if (!Analyze_Exports(module, instance))
   {
      printf("Error: Missing expected entrypoint");
      exit(2);
   }

   _init_fn = wasm_extern_as_func(_exports.data[_export_init_fn]);

   if (!_init_fn)
   {
      printf("Could not access init fn.\n");
      exit(1);
   }

#endif

#if API_WASMTIME
   if (error) {
      wasm_name_t message;
      wasmtime_error_message(error, &message);

      fprintf(stderr, "Wasmtime error: %.*s\n", (int)message.size, message.data);

      wasm_byte_vec_delete(&message);  // free the message buffer
      wasmtime_error_delete(error);    // free the error object
   }
#endif

   if (err) {
      fprintf(stderr, "Error instantiating module.\n");
      exit(1);
   }


#if API_WASMTIME
   wasmtime_extern_t export_;
   bool ok = wasmtime_instance_export_get(_context, &instance, entrypoint, strlen(entrypoint), &export_);
   if (!ok || export_.kind != WASMTIME_EXTERN_FUNC) {
      fprintf(stderr, "Exported function 'app_init' not found.\n");
      exit(1);
   }
#endif


#if API_WASMTIME
   // Call the function (no input params, single int32 result)
   wasmtime_val_t out;
   out.kind = WASM_I32;
   out.of.i32 = 0;

   trap = NULL;
   error = wasmtime_func_call(_context, &export_.of.func, NULL, 0, &out, 1, &trap);

   if (error || trap) {
      fprintf(stderr, "Error calling 'app_init' function.\n");
      exit(1);
   }
#else



#if TEST_INFINITY_APP

   wasm_val_t out;
   out.kind = WASM_I32;
   out.of.i32 = 0;
   wasm_val_vec_t _out = WASM_VEC(out);

   wasm_val_t in[3];
   in[0].kind = WASM_I32;
   in[0].of.i32 = 0; // not used, just test input.

   in[1].kind = WASM_I32;
   in[1].of.i32 = 1; // not used, just test input.

   in[2].kind = WASM_I32;
   in[2].of.i32 = 2; // not used, just test input.


   wasm_val_vec_t _in = WASM_ARRAY_VEC(in);


   if (wasm_func_call(_init_fn, &_in, &_out))
   {
      Logf("Error: Sandbox::init.\n");
   }


   if (out.kind == WASM_I32) {
      int32_t return_value = out.of.i32;
      Logf("Return value: %d\n", return_value);
   }
   else {
      Logf("Unexpected result type.\n");
   }

#else
   wasm_val_vec_t _in = WASM_EMPTY_VEC;
   wasm_val_vec_t _out = WASM_EMPTY_VEC;

   // _start: 0 params, 0 results
   trap = wasm_func_call(_init_fn, &_in, &_out);
   if (trap != NULL) {
      wasm_message_t message;
      wasm_trap_message(trap, &message);
      Logf("Error calling '_start': %.*s\n", (int)message.size, message.data);
      wasm_byte_vec_delete(&message);
      wasm_trap_delete(trap);
      ok = false;
   }
   Logf("Return value: (void)\n");  // No result
#endif


#endif

   printf("\nWASM function '%s' executed successfully.\n", entrypoint);

   // Cleanup
#if API_WASMTIME
   wasmtime_module_delete(module);
   wasmtime_store_delete(_store);
#else
   wasm_module_delete(module);
   wasm_store_delete(_store);
#endif

   wasm_engine_delete(engine);

   return 0;
}





const char* __default_wasm = ".\\app.wasm";


int main(int argc, char* argv[])
{
   // Use wasm filename from command line if specified
   wasm_test((argc >= 2) ? argv[1] : __default_wasm);

   return 0;
}


